<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

/**
 * Linkedin Class
 *
 * Handles all Linkedin functions 
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
if( !class_exists( 'EDD_Slg_Social_LinkedIn' ) ) {
	
	class EDD_Slg_Social_LinkedIn {
		
		public $linkedinconfig, $linkedin;
		
		public function __construct() {
			
		}
		
		/**
		 * Include LinkedIn Class
		 * 
		 * Handles to load Linkedin class
		 * 
		 * @package Easy Digital Downloads - Social Login
	 	 * @since 1.0.0
		 */
		public function edd_slg_load_linkedin() {
			
			global $edd_options;
			
			//linkedin declaration
			if( !empty( $edd_options['edd_slg_enable_linkedin'] )
				 && !empty( $edd_options['edd_slg_li_app_id'] ) && !empty( $edd_options['edd_slg_li_app_secret'] ) ) {

				if( !class_exists( 'LinkedInOAuth2' ) ) {
					require_once( EDD_SLG_SOCIAL_LIB_DIR . '/linkedin/LinkedIn.OAuth2.class.php' );
				}
				
				
				//linkedin api configuration
				$this->linkedinconfig = array(
												'appKey'       => EDD_SLG_LI_APP_ID,
												'appSecret'    => EDD_SLG_LI_APP_SECRET,
												'callbackUrl'  => EDD_SLG_LI_REDIRECT_URL 
											 );
											 
				//Load linkedin outh2 class
				$this->linkedin = new LinkedInOAuth2();
				
				return true;
			} else {
				return false;	
			}
		}

		/**
		 * Extract data from Linkedin response
		 * 
		 * 
		 * @package Easy Digital Downloads - Social Login
	 	 * @since 2.2.1
		 */
		public function edd_slg_get_li_processed_profile_data( $resultData ){
			
			// Declare Global variable
			global $edd_options;

			if( $edd_options['edd_slg_li_scope_type'] == 'signin'){
				$localArr = $resultData['firstName']['preferredLocale'];
				$local = $localArr['language'].'_'.$localArr['country'];
				$user_data = array();

				$profilePicture = isset( $resultData['profilePicture']['displayImage'] ) ? $resultData['profilePicture']['displayImage'] : '';

				$user_data['lastName'] = $resultData['lastName']['localized'][$local];
				$user_data['firstName'] = $resultData['firstName']['localized'][$local];
				$user_data['pictureUrl'] = $profilePicture;
				$user_data['publicProfileUrl'] = '';
				$user_data['emailAddress'] = '';
				$user_data['id'] = $resultData['id'];
			}else{
				$profilePicture = isset( $resultData['picture'] ) ? $resultData['picture'] : '';

				$user_data['lastName'] = $resultData['family_name'];
				$user_data['firstName'] = $resultData['given_name'];
				$user_data['pictureUrl'] = $profilePicture;
				$user_data['publicProfileUrl'] = '';
				$user_data['emailAddress'] = $resultData['email'];
				$user_data['id'] = $resultData['sub'];
			}

			return $user_data;
		}

		
		/**
		 * Linkedin Initialize
		 * 
		 * Handles LinkedIn Login Initialize
		 * 
		 * @package Easy Digital Downloads - Social Login
		 * @since 1.0.0
		 */	
		public function edd_slg_initialize_linkedin() {
		
			global $edd_options;
			
			//check enable linkedin & linkedin application id & linkedin application secret are not empty
			if( !empty( $edd_options['edd_slg_enable_linkedin'] ) && !empty( $edd_options['edd_slg_li_app_id'] )
				 && !empty( $edd_options['edd_slg_li_app_secret'] ) ) {
				
			 	//check $_GET['eddslg'] equals to linkedin
				if( isset( $_GET['eddslg'] ) && $_GET['eddslg'] == 'linkedin' ) {
					
					//load linkedin class
					$linkedin	= $this->edd_slg_load_linkedin();
					$config		= $this->linkedinconfig;
					
					//check linkedin loaded or not
					if( !$linkedin ) return false;
					
					//Get Access token
					$arr_access_token	= $this->linkedin->getAccessToken( $config['appKey'], $config['appSecret'], $config['callbackUrl']);
					
					// code will excute when user does connect with linked in
					if( !empty( $arr_access_token['access_token'] ) ) { // if user allows access to linkedin
						
						//Get User Profiles
						if( $edd_options['edd_slg_li_scope_type'] == 'signin'){
							$resultdata	= $this->linkedin->getProfile();
						}else{
							$resultdata	= $this->linkedin->getIDProfile();
						}

						$resultdata = $this->edd_slg_get_li_processed_profile_data($resultdata);

						$emailData = $this->linkedin->getProfileEmail( $arr_access_token['access_token']);
						
						if( !empty( $emailData ) && isset( $emailData['elements'] ) && !empty( $emailData['elements'] ) ){
							$resultdata['emailAddress'] = $emailData['elements'][0]['handle~']['emailAddress'];
						}

						$imageData = $this->linkedin->getProfileImage( $arr_access_token['access_token']);

						if( !empty( $imageData ) && isset( $imageData['profilePicture'] ) ){
							$resultdata['pictureUrl'] = $imageData['profilePicture']['displayImage~']['elements'][0]['identifiers'][0]['identifier'];
						}
						
						//set user data to sesssion for further use
						EDD()->session->set( 'edd_slg_linkedin_user_cache', $resultdata );
						
						
					} else {
						
						// bad token access
						echo esc_html__( 'Access token retrieval failed', 'eddslg' );
					}
				}
			}
		}
		
		/**
		 * Get LinkedIn Auth URL
		 * 
		 * Handles to return linkedin auth url
		 * 
		 * @package Easy Digital Downloads - Social Login
		 * @since 1.0.0
		 */
		public function edd_slg_linkedin_auth_url() {
			
			// Declare Global variable
			global $edd_options;
			
			//Remove unused scope for login
			if( $edd_options['edd_slg_li_scope_type'] == 'signin' ){
				$scope	= array( 'r_emailaddress', 'r_liteprofile' );
			}else{
				$scope	= array( 'openid', 'email', 'profile' );
			}
			
			//load linkedin class
			$linkedin = $this->edd_slg_load_linkedin();
			
			//check linkedin loaded or not
			if( !$linkedin ) return false;
			
			//Get Linkedin config
			$config	= $this->linkedinconfig;
			
			try {//Prepare login URL
				$preparedurl	= $this->linkedin->getAuthorizeUrl( $config['appKey'], $config['callbackUrl'], $scope );
			} catch( Exception $e ) {
				$preparedurl	= '';
	        }
	        
			return $preparedurl;
		}
		
		/**
		 * Get LinkedIn User Data
		 *
		 * Function to get LinkedIn User Data
		 *
		 * @package Easy Digital Downloads - Social Login
		 * @since 1.0.0
		 */
		public function edd_slg_get_linkedin_user_data() {
		
			$user_profile_data = '';
			
			$user_profile_data = EDD()->session->get( 'edd_slg_linkedin_user_cache' );
			
			return $user_profile_data;
		}
	}
}